class W3Effect_BloodLeash extends CBaseGameplayEffect
{	
	var effect_entity  		: CEntity;
	var second_effect		: SCustomEffectParams;
	
	default isPositive = false;
	default isNeutral = false;
	default isNegative = true;
	default effectType = EET_BloodLeash;
	default attributeName = 'BloodLeash';
		
	event OnEffectAdded(optional customParams : W3BuffCustomParams)
	{
		super.OnEffectAdded(customParams);	
		
		effect_entity = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\blood_moon_leash.w2ent", true ), 
												target.GetWorldPosition(), target.GetWorldRotation() );
		effect_entity.PlayEffect('dust2');							
		target.EnablePathEngineAgent(false);
	}

	event OnEffectRemoved()
	{
		super.OnEffectRemoved();
		
		effect_entity.StopAllEffects();
		effect_entity.DestroyAfter(5);
		
		if ( !target.HasBuff( EET_Rootstrain ) )
		{
			target.EnablePathEngineAgent(true);
		}
	}
}